<?php

namespace App\Modules\TempApplication\Migrations\MaakTransaction;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MaakTransaction extends Model 
{

    protected $table = 'tmp_maak_transactions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function vendor()
    {
        return $this->belongsTo('JackCustomer', 'jack_customer_id');
    }

    public function maak()
    {
        return $this->belongsTo('MaakCustomer', 'maak_customer_id');
    }

}